function out = extblfs(ms)

% Returns the extreme beliefs given a matrix ms whose
% rows record the beliefs under consideration.
%
% It is essentially an application of extpts, but applies
% an extra step to handle the fact that beliefs add up to
% and therefore lack the structure required for convhulln
% to work properly.

% apply extpts after reducing the dimension of ms 

ext = extpts(ms(:,1:(size(ms,2)-1)));

% restore the dimensionality

out = [ext ones(size(ext,1),1)-sum(ext,2)];